using System;
using System.Collections.Generic;
using System.Linq;


namespace _.krug_2.zadatak
{
    internal class Program
    {
        public static int[] Izvrsispoj(int[] levo, int[] desno)
        {
            int[] spojeno = new int[levo.Length + desno.Length];
            int levibrojac = 0;
            int desnibrojac = 0;
            for(int spojenobrojac = 0; spojenobrojac < spojeno.Length; spojenobrojac++)
            {
                if(levibrojac < levo.Length && desnibrojac < desno.Length)
                {
                    if (levo[levibrojac] <= desno[desnibrojac])
                    {
                        spojeno[spojenobrojac] = levo[levibrojac];
                        levibrojac++;
                    }
                    else
                    {
                        spojeno[spojenobrojac] = desno[desnibrojac];
                        desnibrojac++;
                    }
                }
                else if(levibrojac < levo.Length)
                {
                    spojeno[spojenobrojac] = levo[levibrojac];
                    levibrojac++;
                }
                else if(desnibrojac < desno.Length)
                {
                    spojeno[spojenobrojac] = desno[desnibrojac];
                    desnibrojac++;
                }
            }
            return spojeno;
        }

        public static int[] MergeSort(int[] a)
        {
            int[] spojeno = new int[a.Length];
            int presek = a.Length / 2;
            int[] levo;
            int[] desno;
            if (a.Length == 1)
                return a;
            levo = new int[a.Length / 2];
            if(a.Length % 2 == 0)
                desno = new int[a.Length / 2];
            else
                desno = new int[(a.Length / 2) + 1];
            for(int i = 0; i < levo.Length; i++)
                levo[i] = a[i];
            for (int i = 0; i < desno.Length; i++)
                desno[i] = a[i + levo.Length];
            int[] levispoj = MergeSort(levo);
            int[] desnispoj = MergeSort(desno);
            spojeno = Izvrsispoj(levispoj, desnispoj);
            return spojeno;
        }

        public static int[,] IzvrsispojMatrica(int[,] levo, int[,] desno, int glavnired)
        {
            int[,] spojeno = new int[levo.GetLength(0) + desno.GetLength(0), 3];
            int levibrojac = 0;
            int desnibrojac = 0;
            for (int spojenobrojac = 0; spojenobrojac < spojeno.GetLength(0); spojenobrojac++)
            {
                if (levibrojac < levo.GetLength(0) && desnibrojac < desno.GetLength(0))
                {
                    if (levo[levibrojac, glavnired] <= desno[desnibrojac, glavnired])
                    {
                        for(int j = 0; j < 3; j++)
                            spojeno[spojenobrojac, j] = levo[levibrojac, j];
                        levibrojac++;
                    }
                    else
                    {
                        for (int j = 0; j < 3; j++)
                            spojeno[spojenobrojac, j] = desno[desnibrojac, j];
                        desnibrojac++;
                    }
                }
                else if (levibrojac < levo.GetLength(0))
                {
                    for (int j = 0; j < 3; j++)
                        spojeno[spojenobrojac, j] = levo[levibrojac, j];
                    levibrojac++;
                }
                else if (desnibrojac < desno.GetLength(0))
                {
                    for (int j = 0; j < 3; j++)
                        spojeno[spojenobrojac, j] = desno[desnibrojac, j];
                    desnibrojac++;
                }
            }
            return spojeno;
        }

        public static int[,] MergeSortMatrica(int[,] b, int glavnired)
        {
            int[,] spojeno = new int[b.GetLength(0), 3];
            int presek = b.GetLength(0) / 2;
            int[,] levo;
            int[,] desno;
            if (b.GetLength(0) == 1)
                return b;
            levo = new int[b.GetLength(0) / 2, 3];
            if (b.GetLength(0) % 2 == 0)
                desno = new int[b.GetLength(0) / 2, 3];
            else
                desno = new int[(b.GetLength(0) / 2) + 1, 3];
            for (int i = 0; i < levo.GetLength(0); i++)
                for(int j = 0; j < 3; j++)
                    levo[i, j] = b[i, j];
            for (int i = 0; i < desno.GetLength(0); i++)
                for (int j = 0; j < 3; j++)
                    desno[i, j] = b[i + levo.GetLength(0), j];
            int[,] levispoj = MergeSortMatrica(levo, glavnired);
            int[,] desnispoj = MergeSortMatrica(desno, glavnired);
            spojeno = IzvrsispojMatrica(levispoj, desnispoj, glavnired);
            return spojeno;
        }

        public static int[,] ProdjiKrozScenarije(int[] a, int[,] b)
        {
            int j = 0;
            int qbrojac = 0;
            int brojsrednjegelementa = 0;
            for(int i = 0; i < a.Length && j < b.GetLength(0); i++)
            {
                if (a[i] < b[j, 0])
                {
                    qbrojac++;
                }
                else if (a[i] == b[j, 0])
                {
                    brojsrednjegelementa = 0;
                    for(int srednjipoz = i; srednjipoz < a.Length && a[srednjipoz] == b[j, 0]; srednjipoz++)
                        brojsrednjegelementa++;
                    if(qbrojac > a.Length - qbrojac - brojsrednjegelementa)
                    {
                        b[j, 2] = qbrojac - (a.Length - qbrojac - brojsrednjegelementa) - (brojsrednjegelementa - 1) - 1;
                        if (b[j, 2] < 0)
                            b[j, 2] = 0;
                    }
                    else if(qbrojac < a.Length - qbrojac - brojsrednjegelementa)
                    {
                        b[j, 2] = (a.Length - qbrojac - brojsrednjegelementa) - qbrojac - (brojsrednjegelementa - 1);
                        if (b[j, 2] < 0)
                            b[j, 2] = 0;
                    }
                    else
                    {
                        b[j, 2] = 0;
                    }
                    qbrojac++;
                    j++;
                }
                else if(a[i] > b[j, 0])
                {
                    if (qbrojac > a.Length - qbrojac)
                    {
                        b[j, 2] = qbrojac - (a.Length - qbrojac) - 1 + 1;
                        if (b[j, 2] < 0)
                            b[j, 2] = 0;
                    }
                    else if(qbrojac < a.Length - qbrojac)
                    {
                        b[j, 2] = (a.Length - qbrojac) + 1;
                        if (b[j, 2] < 0)
                            b[j, 2] = 0;
                    }
                    else
                    {
                        b[j, 2] = 1;
                    }
                    j++;
                    i--;
                }
            }
            while(j < b.GetLength(0))
            {
                b[j, 2] = qbrojac - 1 + 1;
                j++;
            }
            return b;
        }

        static void Main(string[] args)
        {
            string[] s1 = Console.ReadLine().Split(' ');
            int n = int.Parse(s1[0]);
            int q = int.Parse(s1[1]);
            int[] a = new int[n];
            string[] s2 = Console.ReadLine().Split(' ');
            for(int i = 0; i < n; i++)
                a[i] = int.Parse(s2[i]);
            int[,] b = new int[q, 3];
            string[] s3 = Console.ReadLine().Split(' ');
            for (int i = 0; i < q; i++)
            {
                b[i, 0] = int.Parse(s3[i]);
                b[i, 1] = i;
            }
            a = MergeSort(a);
            b = MergeSortMatrica(b, 0);
            b = ProdjiKrozScenarije(a, b);
            b = MergeSortMatrica(b, 1);
            for (int i = 0; i < q; i++)
            {
                Console.WriteLine(b[i, 2]);
            }
        }
    }
}